#pragma once

#include "GamebaseAuthProvider.h"
#include "GamebaseStoreCode.h"

namespace GamebaseAuth
{
    const FName Domain("GamebaseAuth");

    namespace Logout
    {
        const FString SkipIdpLogout = TEXT("skip_idp_logout");
        const FString SkipExpireGamebaseToken = TEXT("skip_expire_gamebase_token");
        const FString IsInternalCall = TEXT("is_internal_call");
    }

    namespace Store
    {
        struct FProviderStoreInfo
        {
            FString Code;
            bool bBindToken = false;
        };
        
        class FSupportProviderMap
        {
        public:
            FSupportProviderMap()
            {   
                for (const auto& Pair : Map)
                {
                    ReverseMap.Add(Pair.Value.Code, { Pair.Key, Pair.Value.bBindToken });
                }
            }

            TOptional<FProviderStoreInfo> GetProviderByStore(const FString& StoreCode) const
            {
                if (const FProviderStoreInfo* Provider = ReverseMap.Find(StoreCode))
                {
                    return *Provider;
                }
                
                return TOptional<FProviderStoreInfo>();
            }

            TOptional<FProviderStoreInfo> GetStoreByProvider(const FString& Provider) const
            {
                if (const FProviderStoreInfo* Store = Map.Find(Provider))
                {
                    return *Store;
                }
                
                return TOptional<FProviderStoreInfo>();
            }
            
        private:
            TMap<FString, FProviderStoreInfo> Map = {
                { GamebaseAuthProvider::Google, { GamebaseStoreCode::Google, true } },
                { GamebaseAuthProvider::EpicGames, { GamebaseStoreCode::EpicGames, false } }
            };
            
            TMap<FString, FProviderStoreInfo> ReverseMap; 
        };

        const FSupportProviderMap SupportProviderMap = {};
    }
}