#pragma once

#include "GamebaseCoreAuthTypes.h"
#include "GamebaseInternalModule.h"
#include "GamebaseInternalResult.h"
#include "Types/GamebaseAuthTypes.h"

struct FGamebaseWebSocketResponse;
struct FGamebaseAuthToken;
struct FGamebaseError;

class FGamebaseStandaloneContact;
using FGamebaseStandaloneContactPtr = TSharedPtr<FGamebaseStandaloneContact>;

using FGamebaseAuthTokenResult = FGamebaseInternalResult<FGamebaseAuthToken>;
using FGamebaseTemporaryWithdrawalResult = FGamebaseInternalResult<FGamebaseTemporaryWithdrawalInfo>;

class FGamebaseAuthClient final
    : public FGamebaseInternalModule
{
public:
    using FAuthTokenResultCallback = TFunction<void(const FGamebaseAuthTokenResult&)>;
    using FVoidResultCallback = TFunction<void(const FGamebaseErrorResult&)>;
    using FTemporaryWithdrawalResultCallback = TFunction<void(const FGamebaseTemporaryWithdrawalResult&)>;
    
public:
    FGamebaseAuthClient(const FGamebaseWebSocketPtr& WebSocket, const FGamebaseInternalDataPtr& InternalData) :
        FGamebaseInternalModule(WebSocket, InternalData)
    {}

    void SetContact(const FGamebaseStandaloneContactPtr& InContact) { Contact = InContact; }
    
    void RequestIdpLogin(const FString& ProviderName, bool bIsAutoLogin, const FGamebaseAuthCredentials& Credentials, const FAuthTokenResultCallback& Callback);
    void RequestTokenLogin(const FString& ProviderName, const FString& AccessToken, const FGamebaseAuthCredentials& Credentials, const FAuthTokenResultCallback& Callback);
    void RequestBindIdPToken(const FString& ProviderName, const FGamebaseAuthCredentials& Credentials, const FVoidResultCallback& Callback);
    void RequestLogout(const FVoidResultCallback& Callback);
    void RequestWithdraw(const FVoidResultCallback& Callback);
    void RequestTemporaryWithdrawal(const FTemporaryWithdrawalResultCallback& Callback);
    void RequestCancelTemporaryWithdrawal(const FVoidResultCallback& Callback);

private:
    void OnLoginFailedDueToBan(const FGamebaseWebSocketResponse& ResponseSuccessData, const FAuthTokenResultCallback& Callback) const;
    void RequestBanContactUrl(const FString& UserId, const TFunction<void(FString)>& Callback) const;

private:
    FGamebaseStandaloneContactPtr Contact;
};
