﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseAnalytics
{
    struct FParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("userId", UserId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FUserMetaData final : FGamebaseJsonSerializable
    {
        int32 UserLevel;
        int64 LevelUpTime;
        FString ChannelId;
        FString CharacterId;
        FString CharacterClassId;
            
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE("userLevel", UserLevel);
            GAMEBASE_JSON_SERIALIZE("levelUpTime", LevelUpTime);
            GAMEBASE_JSON_SERIALIZE_STRING("channelId", ChannelId);
            GAMEBASE_JSON_SERIALIZE_STRING("characterId", CharacterId);
            GAMEBASE_JSON_SERIALIZE_STRING("characterClassId", CharacterClassId);
        END_GAMEBASE_JSON_SERIALIZER
    };
    
    struct FUserMetaPayload final : FGamebaseBasePayload
    {
        FString AppId;
        FString IdPCode;
        FString ThirdIdPCode;
        FUserMetaData UserMetaData;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("appId", AppId);
            GAMEBASE_JSON_SERIALIZE_STRING("idPCode", IdPCode);
            GAMEBASE_JSON_SERIALIZE_STRING("thirdIdPCode", ThirdIdPCode);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("userMetaData", UserMetaData);
        END_GAMEBASE_JSON_SERIALIZER
    };

    struct FPurchasePayload final : FGamebaseBasePayload
    {
        FString AppId;
        FString PaySeq;
        FString ClientVersion;
        FString IdPCode;
        FString DeviceModel;
        FString OSCode;
        FString UsimCountryCode;
        FString DeviceCountryCode;
        FString SubStoreCode;
        FUserMetaData UserMetaData;
        
        BEGIN_GAMEBASE_JSON_SERIALIZER
            GAMEBASE_JSON_SERIALIZE_STRING("appId", AppId);
            GAMEBASE_JSON_SERIALIZE_STRING("paySeq", PaySeq);
            GAMEBASE_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
            GAMEBASE_JSON_SERIALIZE_STRING("idPCode", IdPCode);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
            GAMEBASE_JSON_SERIALIZE_STRING("osCode", OSCode);
            GAMEBASE_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            GAMEBASE_JSON_SERIALIZE_STRING("subStoreCode", SubStoreCode);
            GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("userMetaData", UserMetaData);
        END_GAMEBASE_JSON_SERIALIZER
    };
}
