﻿#pragma once

#include "CoreMinimal.h"
#include "GamebaseCoreSubsystem.h"
#include "GamebaseStandaloneSubsystem.generated.h"

class FGamebaseWebViewManager;

UCLASS()
class UGamebaseStandaloneSubsystem : public UGamebaseCoreSubsystem
{
    GENERATED_BODY()

public:
    TSharedRef<FGamebaseWebViewManager> GetWebViewManager() const;
    
protected:
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    
    virtual UClass* GetProviderClass() const override;

private:
    TSharedPtr<FGamebaseWebViewManager> WebViewManager;
};