﻿#include "GamebaseStandaloneSubsystem.h"

#include "GamebaseDebugLogger.h"
#include "GamebaseStandaloneProvider.h"
#include "WebView/GamebaseWebViewManager.h"

void UGamebaseStandaloneSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
    bool bEnableAuthGoogle = false;
    bool bEnableAuthFacebook = false;
    bool bEnableAuthAppleId = false;
    bool bEnableAuthLine = false;
    bool bEnableAuthTwitter = false;
    bool bEnableAuthSteam = false;
    bool bEnableAuthEpicGames = false;
    
    bool bEnablePurchaseGooglePlayStore = false;
    bool bEnablePurchaseSteam = false;
    bool bEnablePurchaseEpicGames = false;
    
    FString PurchaseStore;
    
#if PLATFORM_WINDOWS
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnableAuthGoogle"), bEnableAuthGoogle, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnableAuthFacebook"), bEnableAuthFacebook, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnableAuthAppleId"), bEnableAuthAppleId, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnableAuthLine"), bEnableAuthLine, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnableAuthTwitter"), bEnableAuthTwitter, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnableAuthSteam"), bEnableAuthSteam, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnableAuthEpicGames"), bEnableAuthEpicGames, GEngineIni);
    GConfig->GetString(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("WindowsStore"), PurchaseStore, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnablePurchaseGooglePlayStore"), bEnablePurchaseGooglePlayStore, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnablePurchaseSteam"), bEnablePurchaseSteam, GEngineIni);
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), TEXT("bEnablePurchaseEpicGames"), bEnablePurchaseEpicGames, GEngineIni);
#endif
    
    if (bEnableAuthGoogle)
    {
        LoadAdapter("GamebaseStandaloneAuthGoogle");
    }
    if (bEnableAuthFacebook)
    {
        LoadAdapter("GamebaseStandaloneAuthFacebook");
    }
    if (bEnableAuthAppleId)
    {
        LoadAdapter("GamebaseStandaloneAuthAppleId");
    }
    if (bEnableAuthTwitter)
    {
        LoadAdapter("GamebaseStandaloneAuthTwitter");
    }
    if (bEnableAuthSteam)
    {
        LoadAdapter("GamebaseStandaloneAuthSteam");
    }
    if (bEnableAuthLine)
    {
        LoadAdapter("GamebaseStandaloneAuthLine");
    }
    if (bEnableAuthEpicGames)
    {
        LoadAdapter("GamebaseStandaloneAuthEpicGames");
    }

    if (!PurchaseStore.IsEmpty() && !PurchaseStore.Equals("None"))
    {
        if (PurchaseStore.Equals("Steam"))
        {
            bEnablePurchaseSteam = true;
            bEnablePurchaseEpicGames = false;
            bEnablePurchaseGooglePlayStore = false;
        }
        else if (PurchaseStore.Equals("EpicGames"))
        {
            bEnablePurchaseEpicGames = true;
            bEnablePurchaseSteam = false;
            bEnablePurchaseGooglePlayStore = false;
        }
        else if (PurchaseStore.Equals("GooglePlayStore"))
        {
            bEnablePurchaseGooglePlayStore = true;
            bEnablePurchaseEpicGames = false;
            bEnablePurchaseSteam = false;
        }
        else
        {
            GAMEBASE_LOG_GLOBAL_ERROR("An unsupported store is set up.");
            bEnablePurchaseEpicGames = false;
            bEnablePurchaseSteam = false;
            bEnablePurchaseGooglePlayStore = false;
        }
    }
    else
    {
        GAMEBASE_LOG_GLOBAL_DEBUG("The store is not set up.");
    }

    if (bEnablePurchaseSteam)
    {
#if UE_EDITOR
        GAMEBASE_LOG_GLOBAL_WARNING("The steamworks SDK does not work with the editor.");
#else
        LoadAdapter("GamebaseStandalonePurchase");
        LoadAdapter("GamebaseStandalonePurchaseSteam");
#endif
    }
    
    if (bEnablePurchaseEpicGames)
    {
        LoadAdapter("GamebaseStandalonePurchase");
        LoadAdapter("GamebaseStandalonePurchaseEpicGames");
    }
    
    if (bEnablePurchaseGooglePlayStore)
    {
        LoadAdapter("GamebaseStandalonePurchase");
        LoadAdapter("GamebaseStandalonePurchaseGoogle");
    }
    
#if WITH_GAMEBASE_WEBVIEW_ENGINE_PLUGIN
    LoadAdapter("GamebaseStandaloneWebBrowser");
#endif
    
    Super::Initialize(Collection);

    if (!WebViewManager.IsValid())
    {
        WebViewManager = MakeShared<FGamebaseWebViewManager>(GetGameInstance());
    }
}

void UGamebaseStandaloneSubsystem::Deinitialize()
{
    if (WebViewManager.IsValid())
    {
        WebViewManager.Reset();
    }
    
    Super::Deinitialize();
}

UClass* UGamebaseStandaloneSubsystem::GetProviderClass() const
{
    return UGamebaseStandaloneProvider::StaticClass();
}

TSharedRef<FGamebaseWebViewManager> UGamebaseStandaloneSubsystem::GetWebViewManager() const
{
    return WebViewManager.ToSharedRef();
}