#pragma once

#include "GamebaseProvider.h"
#include "Interfaces/IGamebaseAuth.h"
#include "GamebaseStandaloneProvider.generated.h"

class FGamebaseWebSocket;
class FGamebaseStandaloneEventHandler;
class FGamebaseStandaloneAuth;
class FGamebaseStandaloneAnalytics;
class FGamebaseStandaloneContact;
class FGamebaseStandaloneGameNotice;
class FGamebaseStandaloneImageNotice;
class FGamebaseStandaloneLaunching;
class FGamebaseStandalonePurchase;
class FGamebaseStandaloneTerms;
class FGamebaseStandaloneServerPush;
class FGamebaseStandaloneHeartbeat;
class FGamebaseStandaloneIntrospect;
class FGamebaseStandaloneNetwork;
class FGamebaseStandalonePush;
class FGamebaseStandaloneWebView;
class FGamebaseStandaloneSystemInfo;
class FGamebaseStandaloneUtil;
class FGamebaseStandaloneCommunity;

UCLASS()
class UGamebaseStandaloneProvider : public UGamebaseProvider
{
    GENERATED_BODY()

public:
    virtual void Initialize(UGameInstanceSubsystem* Subsystem) override;
    virtual void Deinitialize() override;
    
    virtual void SetDebugMode(bool bDebugMode) override;
    
    virtual void InitializeGamebase(const FGamebaseConfiguration& Configuration, const FGamebaseLaunchingInfoDelegate& Callback) override;

    virtual void Login(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual void LoginForLastLoggedInProvider(const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void LoginForLastLoggedInProvider(const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual void CancelLoginWithExternalBrowser(const FGamebaseErrorDelegate& Callback) override;

    virtual void AddMapping(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual void ChangeLogin(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseVariantMap& CredentialInfo, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void RemoveMapping(const FString& ProviderName, const FGamebaseErrorDelegate& Callback) override;

    virtual void Logout(const FGamebaseErrorDelegate& Callback) override;
    virtual void Withdraw(const FGamebaseErrorDelegate& Callback) override;
    virtual void WithdrawImmediately(const FGamebaseErrorDelegate& Callback) override;
    virtual void RequestTemporaryWithdrawal(const FGamebaseTemporaryWithdrawalDelegate& Callback) override;
    virtual void CancelTemporaryWithdrawal(const FGamebaseErrorDelegate& Callback) override;

    virtual void IssueTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void QueryTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void RenewTransferAccount(const FGamebaseTransferAccountRenewConfiguration& Configuration, const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void TransferAccountWithIdPLogin(const FString& AccountId, const FString& AccountPassword, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual TArray<FString> GetAuthMappingList() override;
    virtual FString GetAuthProviderUserID(const FString& ProviderName) override;
    virtual FString GetAuthProviderAccessToken(const FString& ProviderName) override;
    virtual FGamebaseAuthProviderProfilePtr GetAuthProviderProfile(const FString& ProviderName) override;
    virtual FGamebaseBanInfoPtr GetBanInfo() override;
    
    virtual IGamebaseAnalytics* GetAnalytics() const override;
    virtual IGamebaseContact* GetContact() const override;
    virtual IGamebaseEventHandler* GetEventHandler() const override;
    virtual IGamebaseGameNotice* GetGameNotice() const override;
    virtual IGamebaseImageNotice* GetImageNotice() const override;
    virtual IGamebaseLaunching* GetLaunching() const override;
    virtual IGamebaseNetwork* GetNetwork() const override;
    virtual IGamebasePurchase* GetPurchase() const override;
    virtual IGamebasePush* GetPush() const override;
    virtual IGamebaseSystemInfo* GetSystemInfo() const override;
    virtual IGamebaseTerms* GetTerms() const override;
    virtual IGamebaseUtil* GetUtil() const override;
    virtual IGamebaseWebView* GetWebView() const override;
    virtual IGamebaseCommunity* GetCommunity() const override;
    
    FGamebaseStandaloneServerPush* GetServerPush() const;

private:
    virtual void InitializeInternalModule() override;
    virtual void CreateInternalModule() override;
    virtual void OnInitializeGamebaseCompleted(const FGamebaseLaunchingInfo& LaunchingInfo) override;

    void OnUpdateAuthToken(const TOptional<FGamebaseAuthToken>& AuthToken, const TOptional<FString>& ProviderName);
    
private:
    TSharedPtr<FGamebaseWebSocket> WebSocket;
    TSharedPtr<FGamebaseStandaloneShortTermTicket> ShortTermTicket;
    TSharedPtr<FGamebaseStandaloneEventHandler> EventHandler;
    TSharedPtr<FGamebaseStandaloneAuth> Auth;
    TSharedPtr<FGamebaseStandaloneAnalytics> Analytics;
    TSharedPtr<FGamebaseStandaloneContact> Contact;
    TSharedPtr<FGamebaseStandaloneGameNotice> GameNotice;
    TSharedPtr<FGamebaseStandaloneImageNotice> ImageNotice;
    TSharedPtr<FGamebaseStandaloneLaunching> Launching;
    TSharedPtr<FGamebaseStandalonePurchase> Purchase;
    TSharedPtr<FGamebaseStandaloneTerms> Terms;
    TSharedPtr<FGamebaseStandaloneServerPush> ServerPush;
    TSharedPtr<FGamebaseStandaloneHeartbeat> Heartbeat;
    TSharedPtr<FGamebaseStandaloneIntrospect> Introspect;
    TSharedPtr<FGamebaseStandaloneNetwork> Network;
    TSharedPtr<FGamebaseStandalonePush> Push;
    TSharedPtr<FGamebaseStandaloneWebView> WebView;
    TSharedPtr<FGamebaseStandaloneCommunity> Community;
    TSharedPtr<FGamebaseStandaloneSystemInfo> SystemInfo;
    TSharedPtr<FGamebaseStandaloneUtil> Util;
};