﻿using System.IO;
using NHNCloud.Gamebase;
using UnrealBuildTool;

#if UE_5_0_OR_LATER
using EpicGames.Core;
#else
using Tools.DotNETCommon;
#endif

public class GamebaseStandalone : ModuleRules
{
    public GamebaseStandalone(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
        
        PublicDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "CoreUObject",
                "Gamebase",
                "GamebaseCore",
            }
        );
        
        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "CoreUObject",
                "Engine",
                "Json",
                "JsonUtilities",
                "WebSockets",
                "HTTP",
                "HTTPServer",
                "Projects",
                "Sockets",
                "GamebaseCommon",
                "GpLogger",
            }
        );
        
        PrivateIncludePaths.AddRange(
            new []
            {
                "GamebaseStandalone/Private/Internal",
            }
        );
        
        string platformBinariesPath = Path.GetFullPath(Path.Combine(PluginDirectory, "Binaries", Target.Platform.ToString()));

        if (Target.Platform == UnrealTargetPlatform.Win64)
        {
            const string GamebaseUtilsDllName = "GamebaseUtils.dll";
            string thirdPartyPath = Path.GetFullPath(Path.Combine(ModuleDirectory, "ThirdParty", "GamebaseUtils", Target.Platform.ToString()));
            
            RuntimeDependencies.Add(Path.Combine(platformBinariesPath, GamebaseUtilsDllName), Path.Combine(thirdPartyPath, GamebaseUtilsDllName));
            PublicDelayLoadDLLs.Add(GamebaseUtilsDllName);
            
            PrivateDefinitions.Add("GAMEBASE_UTILS=1");
            
            if (GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_WEBVIEW_ENGINE_PLUGIN))
            {
                PrivateDependencyModuleNames.Add("GamebaseStandaloneWebBrowser");
            }
            
            if (GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_WEBVIEW_GAMEBASE_PLUGIN))
            {
                PrivateDependencyModuleNames.Add("NHNWebView");
            }
            
            if (GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_STANDALONE_PURCHASE))
            {
                PrivateDependencyModuleNames.Add("GamebaseStandalonePurchase");
            }
        }
        else
        {
            Log.TraceWarning("{0} is not supported.", Target.Platform);
            
            PrivateDefinitions.Add("GAMEBASE_UTILS=0");
        }
    }
}