﻿#pragma once

#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "GamebaseWindowsPlatformSettings.generated.h"

UENUM()
enum class EGamebaseWindowsStore : uint8
{
    None                    UMETA(DisplayName = "None"),
    EpicGames               UMETA(DisplayName = "Epic Games Store"),
    Steam                   UMETA(DisplayName = "Steam Store"),
    GooglePlayStore         UMETA(DisplayName = "Google Play Store"),
};


UCLASS(config=Engine, defaultconfig)
class GAMEBASEEDITOR_API UGamebaseWindowsPlatformSettings : public UObject
{
    GENERATED_BODY()

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAuthGoogle;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAuthFacebook;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAuthAppleId;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAuthTwitter;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAuthLine;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAuthSteam;
 
    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAuthEpicGames;
    
    UPROPERTY(config, Meta = (EditCondition = "bEnableAuthEpicGames", DisplayName = "EOS Persistent Auth", HideInEditor))
    bool bEosPersistentAuth;
    
    UPROPERTY(config, EditAnywhere, Category = "Purchase")
    EGamebaseWindowsStore WindowsStore;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Application Id"))
    FString EosApplicationId;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Game Offer Id"))
    FString EosGameOfferId;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Game Name"))
    FString EosGameName;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Artifact Product Id"))
    FString EosArtifactProductId;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Artifact Sandbox Id"))
    FString EosArtifactSandboxId;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Artifact Deployment Id"))
    FString EosArtifactDeploymentId;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Artifact Client Credentials Id"))
    FString EosArtifactClientCredentialsId;

    UPROPERTY(config, EditAnywhere, Category = "Purchase|Epic Games Store",
        Meta = (EditCondition = "WindowsStore == EGamebaseWindowsStore::EpicGames", DisplayName = "EOS Artifact Client Credentials Secret"))
    FString EosArtifactClientCredentialsSecret;
};
