#pragma once

#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "GamebaseIOSPlatformSettings.generated.h"

UCLASS(config=Engine, defaultconfig)
class GAMEBASEEDITOR_API UGamebaseIOSPlatformSettings : public UObject
{
    GENERATED_BODY()

    UPROPERTY(config, EditAnywhere, Category = "Path")
    FString XcodePath = "/Applications/Xcode.app";

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableGoogle;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableFacebook;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAppleId;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableGamecenter;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableTwitter;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableLine;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableNaver;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableSteam;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableEpicGames;

    //UPROPERTY(config, EditAnywhere, Category = "Authentication")
    //bool bEnablePayco;

    //UPROPERTY(config, EditAnywhere, Category = "Authentication")
    //bool bEnableHangame;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableWeibo;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication|Google",
        Meta = (EditCondition = "bEnableGoogle", DisplayName = "ClientId"))
    FString GoogleClientId;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication|Facebook",
        Meta = (EditCondition = "bEnableFacebook", DisplayName = "ClientId"))
    FString FacebookClientId;

    UPROPERTY(config, EditAnywhere, Category = "Authentication|Facebook",
        Meta = (EditCondition = "bEnableFacebook", DisplayName = "ClientToken"))
    FString FacebookClientToken;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication|Weibo",
        Meta = (EditCondition = "bEnableWeibo", DisplayName = "AppKey"))
    FString WeiboAppKey;
    
    UPROPERTY(config, EditAnywhere, Category = "Purchase")
    bool bEnableAppStore;

    UPROPERTY(config, EditAnywhere, Category = "Push")
    bool bEnableAPNS;
};
