#pragma once

#include "CoreMinimal.h"
#include "GamebaseAndroidPlatformSettings.generated.h"

UENUM()
enum class EGamebaseAndroidStore : uint8
{
    None                    UMETA(DisplayName = "None"),
    GooglePlayStore         UMETA(DisplayName = "Google Play Store"),
    OneStore                UMETA(DisplayName = "ONE Store"),
    GalaxyStore             UMETA(DisplayName = "Galaxy Store"),
    AmazonAppstore          UMETA(DisplayName = "Amazon Appstore"),
    HuaweiAppGallery        UMETA(DisplayName = "Huawei AppGallery"),
    MyCard                  UMETA(DisplayName = "MyCard"),
};

UENUM()
enum class EGamebaseOneStoreVersion : uint8
{
    V17,
    V19,
    V21,
};

UENUM()
enum class EGamebaseOneStoreViewOption : uint8
{
    Full                    UMETA(DisplayName = "Full"),
    Popup                   UMETA(DisplayName = "Popup"),
};

UENUM()
enum class EGamebaseGalaxyStoreOperationMode : uint8
{
    Production              UMETA(DisplayName = "Production"),
    Test                    UMETA(DisplayName = "Test - always return success"),
    TestFailure             UMETA(DisplayName = "Test - always return failure"),
};

UCLASS(config=Engine, defaultconfig)
class UGamebaseAndroidPlatformSettings : public UObject
{
    GENERATED_BODY()

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableGoogle;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication", Meta = (DisplayName = "Enable GPGS v2"))
    bool bEnableGPGSv2;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableFacebook;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableAppleId;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableTwitter;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableLine;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableNaver;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnablePayco;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableHangame;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableWeibo;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableSteam;

    UPROPERTY(config, EditAnywhere, Category = "Authentication")
    bool bEnableEpicGames;
    
    UPROPERTY(config, EditAnywhere, Category = "Authentication|GPGS",
        Meta = (EditCondition = "bEnableGPGSv2", DisplayName = "Enable Auto Login"))
    bool bGpgsAutoLogin;

    UPROPERTY(config, EditAnywhere, Category = "Authentication|Hanagame",
        Meta = (EditCondition = "bEnableHangame", DisplayName = "RepositoryPath", Tooltip = "Contact our Customer Center if you want to use the Hangame authentication."))
    FString HangameRepositoryPath;

    UPROPERTY(config, EditAnywhere, Category = "Authentication|Hanagame",
        Meta = (EditCondition = "bEnableHangame", DisplayName = "AccountManagerAuthType", Tooltip = "Contact our Customer Center if you want to use the Hangame authentication."))
    FString HangameAccountManagerAuthType;

    UPROPERTY(config, EditAnywhere, Category = "Push")
    bool bEnableFCM;
    
    UPROPERTY(config, EditAnywhere, Category = "Push")
    bool bEnableADM;
    
    UPROPERTY(config, EditAnywhere, Category = "Push|FCM",
        Meta = (EditCondition = "bEnableFCM", DisplayName = "GoogleServicesFilePath", RelativeToGameDir))
    FFilePath GoogleServicesFilePath;

    UPROPERTY(config, EditAnywhere, Category= "Purchase")
    EGamebaseAndroidStore AndroidStore;
    
    UPROPERTY(config, EditAnywhere, Category = "Purchase|ONE Store",
        Meta = (EditCondition = "AndroidStore == EGamebaseAndroidStore::OneStore", DisplayName = "Store Version"))
    EGamebaseOneStoreVersion OneStoreVersion;
    
    UPROPERTY(config, EditAnywhere, Category = "Purchase|ONE Store",
        Meta = (EditCondition = "AndroidStore == EGamebaseAndroidStore::OneStore", DisplayName = "View Option"))
    EGamebaseOneStoreViewOption OneStoreViewOption;
};