// Copyright 1998-2019 Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;

public class GamebaseEditor : ModuleRules
{
    public GamebaseEditor(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

        PublicDependencyModuleNames.AddRange(
                new[]
                {
                    "Core"
                }
            );

        PrivateIncludePaths.Add("GamebaseEditor/Private");

        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "CoreUObject",
                "Engine",
            }
        );

        if (Target.Type == TargetType.Editor)
        {
            DynamicallyLoadedModuleNames.AddRange(
                new[]
                {
                    "Settings",
                }
            );

            PrivateIncludePathModuleNames.AddRange(
                new[]
                {
                    "Settings",
                }
            );
        }
    }
}
