#pragma once

namespace GamebaseTimeUtils
{
    const FString DateFormat = TEXT("%Y.%m.%d");
    const FString TimeFormat = TEXT("%H:%M");
    const FString DateTimeFormat = TEXT("%Y.%m.%d %H:%M");

    FString PeriadText(const int64& BeginDate, const int64& EndDate) 
    {
        const FDateTime UtcDateTime = FDateTime(1970, 1, 1);
        const FDateTime BeginDateTime = UtcDateTime + FTimespan::FromMilliseconds(BeginDate);
        const FDateTime EndDateTime = UtcDateTime + FTimespan::FromMilliseconds(EndDate);
    
        if (BeginDateTime.GetDate() == EndDateTime.GetDate())
        {
            const FString Date = BeginDateTime.ToString(*DateFormat);
            const FString BeginTime = BeginDateTime.ToString(*TimeFormat);
            const FString EndTime = EndDateTime.ToString(*TimeFormat);

            return FString::Printf(TEXT("%s %s ~ %s"), *Date, *BeginTime, *EndTime);
        }
        else
        {
            const FString BeginTime = BeginDateTime.ToString(*DateTimeFormat);
            const FString EndTime = EndDateTime.ToString(*DateTimeFormat);

            return FString::Printf(TEXT("%s ~ %s"), *BeginTime, *EndTime);
        }
    }
}