#pragma once

#include "JsonObjectConverter.h"

namespace GamebaseJsonConverter
{
    template<typename InStructType>
    static FString UStructToJsonObjectString(const InStructType& InStruct)
    {
        FString JsonString;
        FJsonObjectConverter::UStructToJsonObjectString<InStructType>(InStruct, JsonString, 0, 0, 0, nullptr, false);
        return JsonString;
    }

    template<typename OutStructType>
    static TSharedPtr<OutStructType, ESPMode::ThreadSafe> JsonObjectStringToUStruct(const FString& JsonString)
    {
        OutStructType JsonObject;
        if (FJsonObjectConverter::JsonObjectStringToUStruct<OutStructType>(JsonString, &JsonObject, 0, 0) == false)
        {
            return nullptr;
        }

        return TSharedPtr<OutStructType, ESPMode::ThreadSafe>(new OutStructType(JsonObject));
    }

    template<typename OutStructType>
    static TSharedPtr<TArray<OutStructType>> JsonArrayStringToUStruct(const FString& JsonString)
    {
        TArray<OutStructType> OutStructArray;
        FJsonObjectConverter::JsonArrayStringToUStruct(JsonString, &OutStructArray, 0, 0);

        return TSharedPtr<TArray<OutStructType>>(new TArray<OutStructType>(OutStructArray));
    }

    static FString JsonObjectToJsonString(const TSharedRef<FJsonObject>& JsonObject)
    {
        FString JsonString;
        TSharedRef<TJsonWriter<>> Writer = TJsonWriterFactory<>::Create(&JsonString);
        FJsonSerializer::Serialize(JsonObject, Writer);

        return JsonString;
    }
}