﻿#pragma once

#include "GamebaseJsonSerializerMacros.h"

struct FGamebaseConfiguration;
struct FGamebaseLaunchingInfo;

struct GAMEBASECORE_API FGamebasePurchaseConfiguration final : FGamebaseJsonSerializable
{
    FString ZoneType;
    FString IapAppkey;
    FString StoreCode;
    FString StoreId;
    FString StoreAppId;
    bool bIsLaunchingSandbox;
    FString ServerUrl;
    
    bool IsValid() const
    {
        return !IapAppkey.IsEmpty() && !StoreCode.IsEmpty() && !StoreId.IsEmpty() && !StoreAppId.IsEmpty();
    }
        
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("zoneType", ZoneType);
        GAMEBASE_JSON_SERIALIZE("iapAppkey", IapAppkey);
        GAMEBASE_JSON_SERIALIZE("storeCode", StoreCode);
        GAMEBASE_JSON_SERIALIZE("storeId", StoreId);
        GAMEBASE_JSON_SERIALIZE("storeAppId", StoreAppId);
        GAMEBASE_JSON_SERIALIZE("isLaunchingSandbox", bIsLaunchingSandbox);
        GAMEBASE_JSON_SERIALIZE("serverUrl", ServerUrl);
    END_GAMEBASE_JSON_SERIALIZER
};