 #pragma once

#include "CoreMinimal.h"
#include "Types/GamebaseEventTypes.h"

class IGamebaseEventHandler
{
public:
    virtual ~IGamebaseEventHandler() = default;

    virtual FDelegateHandle AddHandler(const FGamebaseEventDelegate::FDelegate& EventCallback) = 0;
    virtual void RemoveHandler(const FDelegateHandle& EventHandle) = 0;
    virtual void RemoveAllHandler() = 0;
};