﻿#pragma once

#include "GamebaseProvider.h"
#include "GamebaseSubsystem.h"
#include "GamebaseCoreSubsystem.generated.h"

UCLASS(Abstract)
class GAMEBASECORE_API UGamebaseCoreSubsystem : public UGamebaseSubsystem
{
    GENERATED_BODY()

public:
    virtual void SetDebugMode(bool bIsDebugMode) override;
    virtual void SetDisplayLanguageCode(const FString& LanguageCode) const override;
    
    virtual void Initialize(const FGamebaseConfiguration& Configuration, const FGamebaseLaunchingInfoDelegate& Callback) override;
    
    virtual FDelegateHandle AddEventHandler(const FGamebaseEventDelegate::FDelegate& Callback) override;
    virtual void RemoveEventHandler(const FDelegateHandle& Handle) override;
    virtual void RemoveAllEventHandler() override;
    
    virtual void Login(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void LoginForLastLoggedInProvider(const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void LoginForLastLoggedInProvider(const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual void CancelLoginWithExternalBrowser() override;
    
    virtual void AddMapping(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void ChangeLogin(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseVariantMap& CredentialInfo, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void RemoveMapping(const FString& ProviderName, const FGamebaseErrorDelegate& Callback) override;
    
    virtual void Logout(const FGamebaseErrorDelegate& Callback) override;
    virtual void Withdraw(const FGamebaseErrorDelegate& Callback) override;
    
    virtual void IssueTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void QueryTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void RenewTransferAccount(const FGamebaseTransferAccountRenewConfiguration& Configuration,
        const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void TransferAccountWithIdPLogin(const FString& AccountId, const FString& AccountPassword,
        const FGamebaseAuthTokenDelegate& Callback) override;
    
    virtual void RequestLastLoggedInProvider(const FGamebaseLastLoggedInProviderDelegate& Callback) const override;
    virtual FString GetLastLoggedInProvider() const override;
    
    virtual FString GetUserID() const override;
    virtual FString GetAccessToken() const override;
    virtual TArray<FString> GetAuthMappingList() override;
    virtual FString GetAuthProviderUserID(const FString& ProviderName) override;
    virtual FString GetAuthProviderAccessToken(const FString& ProviderName) override;
    virtual FGamebaseAuthProviderProfilePtr GetAuthProviderProfile(const FString& ProviderName) override;
    virtual FGamebaseBanInfoPtr GetBanInfo() override;
    virtual FString GetSDKVersion() const override;
    virtual bool IsSandbox() const override;
    
    virtual FString GetDeviceLanguageCode() const override;
    virtual FString GetCarrierCode() const override;
    virtual FString GetCarrierName() const override;
    virtual FString GetCountryCode() const override;
    virtual FString GetCountryCodeOfUSIM() const override;
    virtual FString GetCountryCodeOfDevice() const override;
    virtual FString GetDisplayLanguageCode() const override;
    
    virtual IGamebaseAnalytics* GetAnalytics() override;
    virtual IGamebaseContact* GetContact() override;
    virtual IGamebaseLaunching* GetLaunching() override;
    virtual IGamebaseLogger* GetLogger() override;
    virtual IGamebaseNetwork* GetNetwork() override;
    virtual IGamebasePurchase* GetPurchase() override;
    virtual IGamebasePush* GetPush() override;
    virtual IGamebaseUtil* GetUtil() override;
    virtual IGamebaseWebView* GetWebView() override;
    virtual IGamebaseGameNotice* GetGameNotice() override;
    virtual IGamebaseImageNotice* GetImageNotice() override;
    virtual IGamebaseTemporaryWithdrawal* GetTemporaryWithdrawal() override;
    virtual IGamebaseTerms* GetTerms() override;
    virtual IGamebaseCommunity* GetCommunity() override;
    
protected:
    // USubsystem interface
    virtual void Initialize(FSubsystemCollectionBase& Collection) override;
    virtual void Deinitialize() override;
    // ~USubsystem interface

    virtual UClass* GetProviderClass() const PURE_VIRTUAL(UGamebaseInternalSubsystem::GetProviderClass, return nullptr;);
    
    void LoadAdapter(const FName& Name);

private:
    UPROPERTY()
    UGamebaseProvider* Provider;

    TUniquePtr<IGamebaseTemporaryWithdrawal> TemporaryWithdrawal;
};