#pragma once

#if PLATFORM_WINDOWS

#include "Windows/AllowWindowsPlatformTypes.h"

class FGamebaseWindowsMessageBox
{
public:
    static int ShowMessageBox(const FString& Title, const FString& Message, const FString& InputButton1 = TEXT(""), const FString&  InputButton2 = TEXT(""));
private:
    static HHOOK HHook;

    static FString Button1;
    static FString Button2;

    static void Register();
    static void Unregister();
    static void ResetButtonText();
    
    static BOOL CALLBACK MessageBoxEnumProc(HWND hWnd, LPARAM lParam);
    static LRESULT CALLBACK MessageBoxHookProc(int nCode, WPARAM wParam, LPARAM lParam);
};

#include "Windows/HideWindowsPlatformTypes.h"

#endif