#include "GamebaseWindowsMessageBox.h"

#if PLATFORM_WINDOWS
#include "GamebaseDebugLogger.h"

HHOOK FGamebaseWindowsMessageBox::HHook = nullptr;
FString FGamebaseWindowsMessageBox::Button1 = TEXT("&OK");
FString FGamebaseWindowsMessageBox::Button2 = TEXT("&Cancel");

UINT MessageBoxType = MB_OK;
int FGamebaseWindowsMessageBox::ShowMessageBox(const FString& Title, const FString& Message, const FString& InputButton1, const FString& InputButton2)
{
    Register();

    MessageBoxType = MB_OK;
    if(InputButton1.IsEmpty() == false)
    {
        Button1 = InputButton1;
    }

    if(InputButton2.IsEmpty() == false)
    {
        Button2 = InputButton2;
        MessageBoxType = MB_OKCANCEL;
    }
    int result = MessageBox(GetActiveWindow(), *Message, *Title, MessageBoxType);

    if (MessageBoxType == MB_OK)
    {
        result = IDOK;
    }
    
    Unregister();

    ResetButtonText();

    return result;
}

void FGamebaseWindowsMessageBox::Register()
{
    if(HHook != nullptr)
    {
        GAMEBASE_LOG_GLOBAL_DEBUG("One hook per thread allowed.");
        return;
    }
    
    HHook = SetWindowsHookEx(WH_CALLWNDPROCRET, MessageBoxHookProc, nullptr, GetCurrentThreadId());
}

void FGamebaseWindowsMessageBox::Unregister()
{
    if(HHook == nullptr)
    {
        return;
    }
    
    UnhookWindowsHookEx(HHook);
    HHook = nullptr;
}

void FGamebaseWindowsMessageBox::ResetButtonText()
{
    Button1 = TEXT("&OK");
    Button2 = TEXT("&Cancel");
}

BOOL CALLBACK FGamebaseWindowsMessageBox::MessageBoxEnumProc(HWND hWnd, LPARAM lParam)
{
    WCHAR className[10] = {0};
    GetClassNameW(hWnd, className, sizeof(className) / sizeof(WCHAR));

    if (FCString::Strcmp(className, TEXT("Button")) == 0)
    {
        int ctlId = GetDlgCtrlID(hWnd);

        if (MessageBoxType == MB_OK)
        {
            if(ctlId == IDCANCEL)
            {
                SetWindowText(hWnd, *Button1);
            }
        }
        else
        {
            switch (ctlId)
            {
            case IDOK:
                SetWindowText(hWnd, *Button1);
                break;
            case IDCANCEL:
                SetWindowText(hWnd, *Button2);    
                break;
            }
        }
    }

    return true;
}

LRESULT CALLBACK FGamebaseWindowsMessageBox::MessageBoxHookProc(int nCode, WPARAM wParam, LPARAM lParam)
{
    if (nCode < 0)
    {
        return CallNextHookEx(HHook, nCode, wParam, lParam);
    }

    CWPRETSTRUCT* msg = (CWPRETSTRUCT*)lParam;
    if (WM_INITDIALOG == msg->message)
    {
        WCHAR className[10] = {0};
        GetClassNameW(msg->hwnd, className, sizeof(className) / sizeof(WCHAR));

        if (FCString::Strcmp(className, TEXT("#32770")) == 0)
        {
            EnumChildWindows(msg->hwnd, MessageBoxEnumProc, 0);
        }
    }
    return (CallNextHookEx(HHook, nCode, wParam, lParam));
}

#undef WINDOWS_PLATFORM_TYPES_GUARD

#endif