#include "GamebaseTimer.h"

FGamebaseTickerDelegateHandle GamebaseTimer::AddTimer(TFunction<void()>&& Callback, const float DelayTime)
{
    double StartTime = FPlatformTime::Seconds();

    return GamebaseTicker::AddTicker(FTickerDelegate::CreateLambda([StartTime, DelayTime, Callback](float Tick)
    {
        const double ElapsedTime = FPlatformTime::Seconds() - StartTime;
        if (ElapsedTime >= DelayTime)
        {
            Callback();
            return false;
        }
        
        return true;
    }), 0.5f);
}

void GamebaseTimer::RemoveTimer(const FGamebaseTickerDelegateHandle& Handle)
{
    GamebaseTicker::RemoveTicker(Handle);
}