#include "GamebaseGenericMics.h"

#include "GamebaseDebugLogger.h"
#include "Internationalization/Culture.h"

FGamebaseMicsResult FGamebaseGenericMics::GetDeviceId()
{
    FString DeviceId = FPlatformMisc::GetDeviceId();
    if (DeviceId.IsEmpty())
    {
        GAMEBASE_LOG_GLOBAL_DEBUG("Failed to get DeviceId from FPlatformMisc::GetDeviceId(). Using OS ID as fallback.");
        DeviceId = FPlatformMisc::GetOperatingSystemId();
    }
    
    return FGamebaseMicsResult::Success(DeviceId);
}

FGamebaseMicsResult FGamebaseGenericMics::GetLocale()
{
    return FGamebaseMicsResult::Success(FInternationalization::Get().GetDefaultLocale()->GetRegion());
}

bool FGamebaseGenericMics::IsNetworkConnected()
{
    return true;
}
