#pragma once

namespace GamebaseInternal
{
    namespace InternalReport
    {
        namespace LogType
        {
            const FString Init = TEXT("Init");
            const FString Auth = TEXT("Auth");
            const FString Event = TEXT("Event");
            const FString Purchase = TEXT("Purchase");
            const FString Push = TEXT("Push");
            const FString Common = TEXT("Common");
            const FString TAA = TEXT("TAA");
            const FString Webview = TEXT("WebView");
            const FString Network = TEXT("Network");
        }

        namespace LogLevel
        {
            const FString Debug = TEXT("DEBUG");
            const FString Info = TEXT("INFO");
            const FString Warn = TEXT("WARN");
            const FString Error = TEXT("ERROR");
            const FString Fatal = TEXT("FATAL");
            const FString None = TEXT("NONE");
        }

        namespace StabilityCode
        {
            namespace Common
            {
                const FString WrongUsage = TEXT("GB_COMMON_WRONG_USAGE");
            }
            
            namespace Init
            {
                const FString FailedMultipleTimes = TEXT("GB_INIT_FAILED_MULTIPLE_TIMES");
            }

            namespace Auth
            {
                const FString LoginSuccess = TEXT("GB_AUTH_LOGIN_SUCCESS");
                const FString LoginFailed = TEXT("GB_AUTH_LOGIN_FAILED");
                const FString LoginCanceled = TEXT("GB_AUTH_LOGIN_CANCELED");
                const FString CredentialLoginSuccess = TEXT("GB_AUTH_CREDENTIAL_LOGIN_SUCCESS");
                const FString CredentialLoginFailed = TEXT("GB_AUTH_CREDENTIAL_LOGIN_FAILED");
                const FString LogoutSuccess = TEXT("GB_AUTH_LOGOUT_SUCCESS");                
                const FString LogoutFailed = TEXT("GB_AUTH_LOGOUT_FAILED");
                const FString WithdrawSuccess = TEXT("GB_AUTH_WITHDRAW_SUCCESS");
                const FString WithdrawFailed = TEXT("GB_AUTH_WITHDRAW_FAILED");
                const FString RequestTemporaryWithdrawalSuccess = TEXT("GB_AUTH_REQUEST_TEMPORARY_WITHDRAWAL_SUCCESS");
                const FString RequestTemporaryWithdrawalFailed = TEXT("GB_AUTH_REQUEST_TEMPORARY_WITHDRAWAL_FAILED");
                const FString CancelTemporaryWithdrawalSuccess = TEXT("GB_AUTH_CANCEL_TEMPORARY_WITHDRAWAL_SUCCESS");
                const FString CancelTemporaryWithdrawalFailed = TEXT("GB_AUTH_CANCEL_TEMPORARY_WITHDRAWAL_FAILED");
            }

            namespace Event
            {
                const FString ObserverBannedMember = TEXT("GB_EVENT_OBSERVER_BANNED_MEMBER");
                const FString ObserverInvalidMember = TEXT("GB_EVENT_OBSERVER_INVALID_MEMBER");
                const FString LoggedOut = TEXT("GB_EVENT_LOGGED_OUT");
            }

            namespace Iap
            {
                const FString InitFailed = TEXT("GB_IAP_INIT_FAILED");
                const FString PurchaseSuccess = TEXT("GB_IAP_PURCHASE_SUCCESS");
                const FString PurchaseFailed = TEXT("GB_IAP_PURCHASE_FAILED");
                const FString PurchaseCanceled = TEXT("GB_IAP_PURCHASE_CANCELED");
                const FString ItemListFailed = TEXT("GB_IAP_ITEM_LIST_FAILED");
                const FString SetUpdateListenerBeforeLogin = TEXT("GB_IAP_SET_UPDATE_LISTENER_BEFORE_LOGIN");
                const FString UpdateListenerNotRegistered = TEXT("GB_IAP_UPDATE_LISTENER_NOT_REGISTERED");
                const FString WrongChangedStoreCode = TEXT("GB_IAP_WRONG_CHANGED_STORECODE");
                const FString PurchaseInvalidReceipt = TEXT("GB_IAP_PURCHASE_INVALID_RECEIPT");
                const FString ConsumableListNotEmpty = TEXT("GB_IAP_CONSUMABLE_LIST_NOT_EMPTY");
                const FString ConsumableListFailed = TEXT("GB_IAP_CONSUMABLE_LIST_FAILED");
            }

            namespace Taa
            {
                const FString SetGameUserDataSuccess = TEXT("GB_TAA_SET_GAME_USER_DATA_SUCCESS");
                const FString SetGameUserDataFailed = TEXT("GB_TAA_SET_GAME_USER_DATA_FAILED");
                const FString TraceLevelUpSuccess = TEXT("GB_TAA_TRACE_LEVEL_UP_SUCCESS");
                const FString TraceLevelUpFailed = TEXT("GB_TAA_TRACE_LEVEL_UP_FAILED");
                const FString PurchaseCompleteSuccess = TEXT("GB_TAA_PURCHASE_COMPLETE_SUCCESS");
                const FString PurchaseCompleteFailed = TEXT("GB_TAA_PURCHASE_COMPLETE_FAILED");
                const FString ResetUserLevel = TEXT("GB_TAA_RESET_USER_LEVEL");
            }
            
            namespace WebView
            {
                const FString OpenFailed = TEXT("GB_WEBVIEW_OPEN_FAILED");
            }

            namespace Network
            {
                const FString ChangeDomainSuccess = TEXT("GB_NETWORK_CHANGE_DOMAIN_SUCCESS");
                const FString DomainConnectionFailed = TEXT("GB_NETWORK_DOMAIN_CONNECTION_FAILED");
            }
            
            const FString LogDebugReport = TEXT("UE_DEBUG_REPORT");
            const FString LogWarnReport = TEXT("UE_WARN_REPORT");
            const FString LogErrorReport = TEXT("UE_ERROR_REPORT");
            const FString LogApiUsedReport = TEXT("UE_DEBUG_REPORT");
        }
        
        namespace SubCategory
        {
            const FString Login = TEXT("Login");
            const FString Logout = TEXT("Logout");
            const FString AddMapping = TEXT("AddMapping");
            const FString Withdraw = TEXT("Withdraw");
            const FString TransferAccount = TEXT("TransferAccount");
            const FString TemporaryWithdrawal = TEXT("TemporaryWithdrawal");
        }
        
        namespace StabilityKey
        {
            const FString GameName = TEXT("GBGameName");
            const FString StabilityCode = TEXT("GBStabilityCode");
            const FString Platform = TEXT("GBPlatform");
            const FString ProjectAppId = TEXT("GBProjectAppID");
            const FString SubCategory1 = TEXT("GBSubCategory1");
            const FString AppClientVersion = TEXT("GBAppClientVersion");
            const FString LaunchingZone = TEXT("GBLaunchingZone");
            const FString UnrealSDKVersion = TEXT("GBUnrealSDKVersion");
            const FString ServerApiVersion = TEXT("GBServerAPIVersion");
            const FString InternalReportVersion = TEXT("GBInternalReportVersion");
            const FString LastLoggedInIdp = TEXT("GBLastLoggedInIDP");
            const FString LastLoggedInUserId = TEXT("GBLastLoggedInUserID");
            const FString GuestUuid = TEXT("GBGuestUUID");        
            const FString DeviceLanguageCode = TEXT("GBDeviceLanguageCode");
            const FString DisplayLanguageCode = TEXT("GBDisplayLanguageCode");
            const FString CountryCodeUSIM = TEXT("GBCountryCodeUSIM");
            const FString CountryCodeDevice = TEXT("GBCountryCodeDevice");
            const FString NetworkType = TEXT("GBNetworkType");
            const FString GameEngine = TEXT("GBGameEngine");
            const FString Carrier = TEXT("GBCarrier");
            const FString DeviceModel = TEXT("GBDeviceModel");
            const FString Exception = TEXT("txtGBException");
            const FString ErrorCode = TEXT("GBErrorCode");
            const FString ErrorDomain = TEXT("GBErrorDomain");
            const FString ExceptionID = TEXT("GBExceptionID");
            const FString DetailErrorCode = TEXT("GBDetailErrorCode");
            const FString DetailErrorMessage = TEXT("GBDetailErrorMessage");
            const FString IsUserCanceled = TEXT("GBIsUserCanceled");
            const FString IsExternalLibraryError = TEXT("GBIsExternalLibraryError");
            const FString DeviceKey = TEXT("GBDeviceKey");
        }

        namespace AdditionalKey
        {
            const FString Configuration = TEXT("txtGBConfiguration");
            const FString LoginIdp = TEXT("GBLoginIDP");
            const FString Credential = TEXT("txtGBCredential");
            const FString TcIapAppKey = TEXT("GBTCIapAppKey");
            const FString ItemSeq = TEXT("GBItemSeq");
            const FString GamebaseProductId = TEXT("GBGamebaseProductId");
            const FString PurchaseType = TEXT("GBPurchaseType");
            const FString Price = TEXT("GBPrice");
            const FString PaymentSeq = TEXT("GBPaymentSeq");
            const FString PurchasePayload = TEXT("GBPurchasePayload");
            const FString PurchasableReceipt = TEXT("txtGBPurchasableReceipt");
            const FString PurchasableReceipts = TEXT("txtGBPurchasableReceipts");
            const FString CurrentStoreCode = TEXT("GBCurrentStoreCode");
            const FString NewStoreCode = TEXT("GBNewStoreCode");
            const FString IsExternalLibraryError = TEXT("GBIsExternalLibraryError");
            const FString IsUserCanceled = TEXT("GBIsUserCanceled");
            const FString PurchaseInitSettings = TEXT("txtGBPurchaseInitSettings");
            const FString ObserverData = TEXT("txtGBObserverData");
            const FString EventLoggedOutData = TEXT("txtGBEventLoggedOutData");
            const FString SubCategory1 = TEXT("GBSubCategory1");
            const FString TaaUserLevel = TEXT("GBTAAUserLevel");
            const FString GameUserData = TEXT("txtGBGameUserData");
            const FString LevelUpData = TEXT("txtGBLevelUpData");
            const FString StoreCode = TEXT("GBStoreCode");
            const FString FunctionName = TEXT("GBFunctionName");
            const FString ErrorLog = TEXT("GBErrorLog");
            const FString WrongUsagePayload = TEXT("GBWrongUsagePayload");
            const FString Exception = TEXT("GBException");
            const FString WebviewConfiguration = TEXT("txtGBWebViewConfiguration");
            const FString Url = TEXT("GBURL");
            const FString Domain = TEXT("GBDomain");
        
            const FString GamebaseLog = TEXT("GAMEBASE_LOG");
        }

    }

    namespace GameInformationReport
    {
        namespace Body
        {
            const FString GameInformation = "GB_GAME_INFORMATION";
        }
        
        namespace Key
        {
            const FString BasicDataKeyAppId = "GBAppID";
            const FString BasicDataKeyUuid = "GBUUID";
            const FString BasicDataKeyUserId = "GBUserId";
            const FString BasicDataKeyAppVersion = "GBClientVersion";
            const FString SendDataKeyClientLogTime = "GBClientLogTime";
            
            const FString LaunchingZone = "GBLaunchingZone";
            const FString Platform = "GBPlatform";
            const FString PlatformSdkVersion = "GBPlatformSDKVersion";
            const FString PlatformVersion = "GBPlatformVersion";
            const FString EngineType = "GBEngineType";
            const FString EngineSdkVersion = "GBEngineSDKVersion";
            const FString EngineVersion = "GBEngineVersion";
            const FString CountryCode = "GBCountryCode";
            const FString UsedApiList = "txtGBUsedApiList";
        }
    }

}
