#include "GamebasePopup.h"

#if PLATFORM_WINDOWS
#include "Windows/GamebaseWindowsMessageBox.h"
#else
#include "Misc/MessageDialog.h"
#endif

void GamebasePopup::ShowPopup(const FString& Title, const FString& Message, const FGamebasePopupButtonPtr Button1, const FGamebasePopupButtonPtr Button2)
{
    const FString ButtonName1 = Button1.IsValid() ? Button1->Name : "";
    const FString ButtonName2 = Button2.IsValid() ? Button2->Name : "";
    
#if PLATFORM_WINDOWS
    int Result = FGamebaseWindowsMessageBox::ShowMessageBox(Title, Message, ButtonName1, ButtonName2);
    switch (Result)
    {
        case IDOK:
            {
                if (Button1.IsValid() && Button1->Callback)
                {
                    Button1->Callback();
                }
                break;
            }
        case IDCANCEL:
            {
                if (Button2.IsValid() && Button2->Callback)
                {
                    Button2->Callback();
                }
                break;
            }
        default: ;
    }
#else
    const FText TitleText = FText::FromString(*Title);
    const FText MessageText = FText::FromString(*Message);

    EAppMsgType::Type MsgType = EAppMsgType::Ok;
    if (ButtonName2.IsEmpty() == false)
    {
        MsgType = EAppMsgType::YesNo;
    }
    const EAppReturnType::Type DialogResult = FMessageDialog::Open(MsgType, MessageText, &TitleText);
    if (DialogResult == EAppReturnType::Type::No)
    {
        if (Button2.IsValid() && Button2->Callback)
        {
            Button2->Callback();
        }
    }
    else if (DialogResult == EAppReturnType::Type::Ok ||
             DialogResult == EAppReturnType::Type::Yes)
    {
        if (Button1.IsValid() && Button1->Callback)
        {
            Button1->Callback();
        }
    }
    else
    {
        if (Button1.IsValid() && Button1->Callback)
        {
            Button1->Callback();
        }
    }
#endif
}