#include "GamebaseInternalData.h"

#include "GamebaseDeviceInfo.h"
#include "IGamebaseDisplayLanguage.h"

void FGamebaseInternalData::SetLaunchingInfo(
    const FGamebaseLaunchingInfoPtr& NewLaunchingInfo)
{
    LaunchingInfo = NewLaunchingInfo;
        
    if (LaunchingInfo.IsValid())
    {
        const auto& LaunchingLanguageInfo = LaunchingInfo->Launching.App.Language;
        DisplayLanguage->UpdateLaunchingLanguageCode(LaunchingLanguageInfo.DefaultLanguage, LaunchingLanguageInfo.DefaultLanguage);
    }
}

FString FGamebaseInternalData::GetUuid() const
{
    if (!Udid.IsSet())
    {
        Udid = FGamebaseDeviceInfo::Get().GetUUID();
    }

    return Udid.Get(FString());
}

FString FGamebaseInternalData::GetDisplayLanguageCode() const
{
    return DisplayLanguage.IsValid() ? DisplayLanguage->GetDisplayLanguageCode() : FString();
}
