﻿#pragma once

template <typename T>
class TGamebaseImmutableData
{
public:
    TGamebaseImmutableData() = default;

    explicit TGamebaseImmutableData(const T& InData) : Data(InData) {}
    explicit TGamebaseImmutableData(T&& InData) : Data(MoveTemp(InData)) {}

    TGamebaseImmutableData(const TGamebaseImmutableData&) = delete;
    TGamebaseImmutableData& operator=(const TGamebaseImmutableData&) = delete;
    
    const T& operator*() const
    {
        check(Data.IsSet());
        return Data.GetValue();
    }

    const T* operator->() const
    {
        check(Data.IsSet());
        return &Data.GetValue();
    }
    
    void Set(const T& InData)
    {
        check(!Data.IsSet());
        Data = InData;
    }

    void Set(T&& InData)
    {
        check(!Data.IsSet());
        Data = MoveTemp(InData);
    }

    const T& Get() const
    {
        check(Data.IsSet());
        return Data.GetValue();
    }

    bool IsSet() const { return Data.IsSet(); }
    
private:
    TOptional<T> Data;
};