#pragma once

#include "CoreMinimal.h"
#include "GamebaseAdapterBase.h"
#include "GamebaseAuthTypes.h"
#include "GamebaseBaseTypes.h"
#include "GamebaseCoreAuthTypes.h"
#include "GamebaseBridgeAuthAdapter.generated.h"

UCLASS(Abstract)
class GAMEBASEBRIDGE_API UGamebaseBridgeAuthAdapter
    : public UGamebaseAdapterBase
{
    GENERATED_BODY()

public:
    using FLoginCallback = TFunction<void(const FGamebaseAuthCredentialsResult&)>;
    using FLogoutCallback = TFunction<void()>;
    using FWithdrawCallback = TFunction<void()>;
    
    virtual void Initialize()
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::Initialize,);
    
    virtual void Login(const FLoginCallback& Callback)
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::Login,);
    
    virtual void Login(const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback)
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::Login,);
    
    virtual void Logout(const FLogoutCallback& Callback)
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::Logout,);
    
    virtual void Withdraw(const FWithdrawCallback& Callback)
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::Withdraw,);
    
    virtual FString GetProviderName() const
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::GetProviderName, return {};);
    
    virtual FString GetUserID() const
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::GetUserID, return {};);
    
    virtual FString GetAccessToken() const
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::GetAccessToken, return {};);
    
    virtual FGamebaseAuthProviderProfilePtr GetProfile() const
        PURE_VIRTUAL(UGamebaseBridgeAuthAdapter::GetProfile, return {};);

protected:
    virtual bool ShouldCollectWithKey() const override final { return true; }
};
