#include "GamebaseIOSPush.h"
#include "GamebaseCommunicationRequestTypes.h"

namespace GamebaseScheme
{
    const FName SetSandboxMode(TEXT("gamebase://setSandboxMode"));
}

void FGamebaseIOSPush::SetSandboxMode(const bool bIsSandbox)
{
    FPushIsSandboxMode ModeData;
    ModeData.bIsSandbox = bIsSandbox;

    FGamebaseCommunicatorSendData Data{ GamebaseScheme::SetSandboxMode };
    Data.JsonData = ModeData.ToJson(false);

    Communicator->GetAsyncWithoutResponse(Data.ToJson(false));
}
