#include "GamebaseIOSCommunicator.h"

#import <GamebasePlugin/GamebasePlugin.h>

extern "C" {
    void initialize(char* className);
    char* getSync(char* jsonString);
    void getAsync(char* jsonString);
}

void FGamebaseIOSCommunicator::Initialize(const FName& ClassName)
{
    const FString NameString = ClassName.ToString();
    initialize(TCHAR_TO_UTF8(*NameString));
}

void FGamebaseIOSCommunicator::GetAsync(const FString& JsonString)
{
    getAsync(TCHAR_TO_UTF8(*JsonString));
}

FString FGamebaseIOSCommunicator::GetSync(const FString& JsonString)
{
    return FString(UTF8_TO_TCHAR(getSync(TCHAR_TO_UTF8(*JsonString))));
}
