#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebaseUtil.h"

class FGamebaseBridgeUtil : public IGamebaseUtil, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeUtil(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeUtil() override = default;

    virtual void ShowAlert(const FString& Title, const FString& Message) override;
    virtual void ShowAlert(const FString& Title, const FString& Message, const FGamebaseAlertCloseDelegate& CloseCallback) override;
    virtual void ShowToast(const FString& Message, EGamebaseToastExposureTime ExposureTimeType) override;

    virtual void ShowAlert(TMap<FString, FString> Parameters, const FGamebaseAlertDelegate& Callback) override;
};
