#include "GamebaseBridgeUtil.h"
#include "GamebaseCommunicationRequestTypes.h"
#include "GamebaseCommunicator.h"
#include "GamebaseCommunicatorAsyncSender.h"
#include "GamebaseCommunicatorManager.h"

namespace GamebaseScheme
{
    const FName ShowToastWithType(TEXT("gamebase://showToastWithType"));
    const FName ShowAlert(TEXT("gamebase://showAlert"));
    const FName ShowAlertEvent(TEXT("gamebase://showAlertEvent"));
}


FGamebaseBridgeUtil::FGamebaseBridgeUtil(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeUtil::ShowAlert(const FString& Title, const FString& Message)
{
    FUtilAlertDialog DialogData;
    DialogData.Title = Title;
    DialogData.Message = Message;

    FGamebaseCommunicatorSendData Data { GamebaseScheme::ShowAlert };
    Data.JsonData = DialogData.ToJson(false);

    Communicator->GetAsyncWithoutResponse(Data.ToJson(false));
}

void FGamebaseBridgeUtil::ShowAlert(const FString& Title, const FString& Message, const FGamebaseAlertCloseDelegate& CloseCallback)
{
    FUtilAlertDialog DialogData;
    DialogData.Title = Title;
    DialogData.Message = Message;

    FGamebaseCommunicatorSendData Data { GamebaseScheme::ShowAlertEvent };
    Data.JsonData = DialogData.ToJson(false);

    Communicator->RegisterAsyncEvent(Data, [=](const FGamebaseCommunicatorReceiveDataRef& ReceiveData)
    {
        CloseCallback.ExecuteIfBound();
    });
}

void FGamebaseBridgeUtil::ShowToast(const FString& Message, EGamebaseToastExposureTime ExposureTimeType)
{
    FUtilAlertDialog DialogData;
    DialogData.Message = Message;
    DialogData.Duration = static_cast<int32>(ExposureTimeType);

    FGamebaseCommunicatorSendData Data { GamebaseScheme::ShowToastWithType };
    Data.JsonData = DialogData.ToJson(false);

    Communicator->GetAsyncWithoutResponse(Data.ToJson(false));
}

void FGamebaseBridgeUtil::ShowAlert(TMap<FString, FString> Parameters, const FGamebaseAlertDelegate& Callback)
{
    static const FString KeyTitle(TEXT("title"));
    static const FString KeyMessage(TEXT("message"));
    static const FString KeyButtonLeft(TEXT("buttonLeft"));
    static const FString KeyButtonRight(TEXT("buttonRight"));
    
    FUtilAlertDialog DialogData;
    DialogData.Title = KeyTitle;
    DialogData.Message = KeyMessage;

    FGamebaseCommunicatorSendData Data { GamebaseScheme::ShowAlertEvent };
    Data.JsonData = DialogData.ToJson(false);

    Communicator->RegisterAsyncEvent(Data, [=](const FGamebaseCommunicatorReceiveDataRef& ReceiveData)
    {
        Callback.ExecuteIfBound(0);
    });
}