#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebaseTerms.h"

class FGamebaseBridgeTerms : public IGamebaseTerms, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeTerms(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeTerms() override = default;

    virtual void ShowTermsView(const FGamebaseDataContainerDelegate& CloseCallback) override;
    virtual void ShowTermsView(const FGamebaseTermsConfiguration& Configuration, const FGamebaseDataContainerDelegate& CloseCallback) override;
    virtual void UpdateTerms(const FGamebaseUpdateTermsConfiguration& Configuration, const FGamebaseErrorDelegate& Callback) override;
    virtual void QueryTerms(const FGamebaseQueryTermsResultDelegate& Callback) override;
    virtual bool IsShowingTermsView() override;
};
