﻿// Fill out your copyright notice in the Description page of Project Settings.


#include "GamebaseBridgeSubsystem.h"

#include "GamebaseBridgeProvider.h"

void UGamebaseBridgeSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
    bool bEnableAuthEpicGames = false;
    
#if PLATFORM_ANDROID
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseAndroidPlatformSettings"), TEXT("bEnableEpicGames"), bEnableAuthEpicGames, GEngineIni);
#elif PLATFORM_IOS
    GConfig->GetBool(TEXT("/Script/GamebaseEditor.GamebaseIOSPlatformSettings"), TEXT("bEnableEpicGames"), bEnableAuthEpicGames, GEngineIni);
#endif
    
    if (bEnableAuthEpicGames)
    {
        LoadAdapter("GamebaseBridgeAuthEpicGames");
    }

    Super::Initialize(Collection);    
}

void UGamebaseBridgeSubsystem::Deinitialize()
{
    Super::Deinitialize();
}

UClass* UGamebaseBridgeSubsystem::GetProviderClass() const
{
    return UGamebaseBridgeProvider::StaticClass();
}
