// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "GamebaseProvider.h"
#include "GamebaseBridgeProvider.generated.h"

class IGamebaseAnalytics;
class IGamebaseEventHandler;
class IGamebaseSystemInfo;
class IGamebaseAuth;
class IGamebaseCore;
class IGamebaseTerms;
class IGamebaseTemporaryWithdrawal;
class IGamebaseImageNotice;
class IGamebaseWebView;
class IGamebaseUtil;
class IGamebasePush;
class IGamebasePurchase;
class IGamebaseNetwork;
class IGamebaseContact;
class IGamebaseLaunching;
class IGamebaseCommunity;
class IGamebaseCommunicator;
class FGamebaseCommunicatorManager;

UCLASS()
class GAMEBASEBRIDGE_API UGamebaseBridgeProvider : public UGamebaseProvider
{
    GENERATED_BODY()

public:
    static UGamebaseBridgeProvider* GetInstance();
    
    virtual void Initialize(UGameInstanceSubsystem* Subsystem) override;
    virtual void Deinitialize() override;
    
    virtual void InitializeGamebase(const FGamebaseConfiguration& Configuration, const FGamebaseLaunchingInfoDelegate& Callback) override;
    virtual void SetDebugMode(bool bDebugMode) override;

    FGamebaseCommunicatorManager* GetCommunicator() const { return CommunicatorManager.Get(); }
    
#define GAMEBASE_BRIDGE_MODULE_GETTER(Module)      virtual IGamebase##Module* Get##Module() const override { return Module.Get(); }
    GAMEBASE_BRIDGE_MODULE_GETTER(Analytics);
    GAMEBASE_BRIDGE_MODULE_GETTER(Auth);
    GAMEBASE_BRIDGE_MODULE_GETTER(Contact);
    GAMEBASE_BRIDGE_MODULE_GETTER(GameNotice);
    GAMEBASE_BRIDGE_MODULE_GETTER(EventHandler);
    GAMEBASE_BRIDGE_MODULE_GETTER(ImageNotice);
    GAMEBASE_BRIDGE_MODULE_GETTER(Launching);
    GAMEBASE_BRIDGE_MODULE_GETTER(Network);
    GAMEBASE_BRIDGE_MODULE_GETTER(Purchase);
    GAMEBASE_BRIDGE_MODULE_GETTER(Push);
    GAMEBASE_BRIDGE_MODULE_GETTER(SystemInfo);
    GAMEBASE_BRIDGE_MODULE_GETTER(Terms);
    GAMEBASE_BRIDGE_MODULE_GETTER(Util);
    GAMEBASE_BRIDGE_MODULE_GETTER(WebView);
    GAMEBASE_BRIDGE_MODULE_GETTER(Community);
    
    virtual void Login(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual void LoginForLastLoggedInProvider(const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void LoginForLastLoggedInProvider(const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual void CancelLoginWithExternalBrowser(const FGamebaseErrorDelegate& Callback) override;

    virtual void AddMapping(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual void ChangeLogin(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseVariantMap& CredentialInfo, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void RemoveMapping(const FString& ProviderName, const FGamebaseErrorDelegate& Callback) override;

    virtual void Logout(const FGamebaseErrorDelegate& Callback) override;
    virtual void Withdraw(const FGamebaseErrorDelegate& Callback) override;
    virtual void WithdrawImmediately(const FGamebaseErrorDelegate& Callback) override;
    virtual void RequestTemporaryWithdrawal(const FGamebaseTemporaryWithdrawalDelegate& Callback) override;
    virtual void CancelTemporaryWithdrawal(const FGamebaseErrorDelegate& Callback) override;

    virtual void IssueTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void QueryTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void RenewTransferAccount(const FGamebaseTransferAccountRenewConfiguration& Configuration, const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void TransferAccountWithIdPLogin(const FString& AccountId, const FString& AccountPassword, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual TArray<FString> GetAuthMappingList() override;
    virtual FString GetAuthProviderUserID(const FString& ProviderName) override;
    virtual FString GetAuthProviderAccessToken(const FString& ProviderName) override;
    virtual FGamebaseAuthProviderProfilePtr GetAuthProviderProfile(const FString& ProviderName) override;
    virtual FGamebaseBanInfoPtr GetBanInfo() override;
    
protected:
    virtual void OnInitializeGamebaseCompleted(const FGamebaseLaunchingInfo& LaunchingInfo) override;

private:
    virtual void CreateInternalModule() override;
    virtual bool ShouldCreateModule() const override;
    virtual bool IsCreateModule() const override;

private:
    TSharedPtr<FGamebaseCommunicatorManager> CommunicatorManager;
    
    TSharedPtr<IGamebaseCore> Core;
    TSharedPtr<IGamebaseAuth> Auth;
    TSharedPtr<IGamebaseAnalytics> Analytics;
    TSharedPtr<IGamebaseContact> Contact;
    TSharedPtr<IGamebaseGameNotice> GameNotice;
    TSharedPtr<IGamebaseEventHandler> EventHandler;
    TSharedPtr<IGamebaseImageNotice> ImageNotice;
    TSharedPtr<IGamebaseLaunching> Launching;
    TSharedPtr<IGamebasePurchase> Purchase;
    TSharedPtr<IGamebaseTerms> Terms;
    TSharedPtr<IGamebaseNetwork> Network;
    TSharedPtr<IGamebasePush> Push;
    TSharedPtr<IGamebaseWebView> WebView;
    TSharedPtr<IGamebaseCommunity> Community;
    TSharedPtr<IGamebaseSystemInfo> SystemInfo;
    TSharedPtr<IGamebaseUtil> Util;
};
