#include "GamebaseBridgeNetwork.h"
#include "GamebaseCommunicator.h"

namespace GamebaseScheme
{
    const FName GetType(TEXT("gamebase://getType"));
    const FName GetTypeName(TEXT("gamebase://getTypeName"));
    const FName IsConnected(TEXT("gamebase://isConnected"));
}

FGamebaseBridgeNetwork::FGamebaseBridgeNetwork(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

EGamebaseNetworkType FGamebaseBridgeNetwork::GetNetworkType() const
{
    const FGamebaseCommunicatorSendData Data { GamebaseScheme::GetType };

    const FString GetJsonString = Communicator->GetSync(Data.ToJson(false));
    if (GetJsonString.IsEmpty())
    {
        return EGamebaseNetworkType::Not;
    }

    return static_cast<EGamebaseNetworkType>(static_cast<uint8>(FCString::Atoi(*GetJsonString)));
}

FString FGamebaseBridgeNetwork::GetNetworkTypeName() const
{
    const FGamebaseCommunicatorSendData Data { GamebaseScheme::GetTypeName };

    return Communicator->GetSync(Data.ToJson(false));
}

bool FGamebaseBridgeNetwork::IsConnected() const
{
    const FGamebaseCommunicatorSendData Data { GamebaseScheme::IsConnected };

    const FString GetJsonString = Communicator->GetSync(Data.ToJson(false));
    if (GetJsonString.IsEmpty())
    {
        return false;
    }

    const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<>::Create(GetJsonString);
    TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject());

    if (FJsonSerializer::Deserialize(JsonReader, JsonObject) == false)
    {
        return false;
    }

    return JsonObject->GetBoolField(TEXT("isConnected"));
}
