#include "GamebaseBridgeLaunching.h"
#include "GamebaseCommunicator.h"

namespace GamebaseScheme
{
    const FName GetLaunchingInformations(TEXT("gamebase://getLaunchingInformations"));
    const FName GetLaunchingStatus(TEXT("gamebase://getLaunchingStatus"));
}

FGamebaseBridgeLaunching::FGamebaseBridgeLaunching(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

const FGamebaseLaunchingInfoPtr FGamebaseBridgeLaunching::GetLaunchingInformations() const
{
    const FGamebaseCommunicatorSendData Data { GamebaseScheme::GetLaunchingInformations };

    const FString GetJsonString = Communicator->GetSync(Data.ToJson(false));
    if (GetJsonString.IsEmpty())
    {
        return nullptr;
    }
    
    const FGamebaseLaunchingInfoPtr LaunchingInfo = MakeShared<FGamebaseLaunchingInfo, ESPMode::ThreadSafe>();
    LaunchingInfo->FromJson(GetJsonString);
    
    return LaunchingInfo;
}

int32 FGamebaseBridgeLaunching::GetLaunchingStatus() const
{
    const FGamebaseCommunicatorSendData Data { GamebaseScheme::GetLaunchingStatus };

    const FString GetJsonString = Communicator->GetSync(Data.ToJson(false));
    if (GetJsonString.IsEmpty())
    {
        return 0;
    }

    return FCString::Atoi(*GetJsonString);
}
