#include "GamebaseBridgeImageNotice.h"
#include "GamebaseCommunicatorTypes.h"
#include "GamebaseCommunicatorAsyncSender.h"
#include "GamebaseCommunicationRequestTypes.h"

namespace GamebaseScheme
{
    const FName ShowImageNotices(TEXT("gamebase://showImageNotices"));
    const FName CloseImageNotices(TEXT("gamebase://closeImageNotices"));
    const FName NoticeSchemeEvent(TEXT("gamebase://schemeEventImageNotices"));
}

namespace
{
    int32 NoticeSchemeHandleNumber = 0;
}

FGamebaseBridgeImageNotice::FGamebaseBridgeImageNotice(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
    Communicator->RegisterEvent(GamebaseScheme::NoticeSchemeEvent, [=](const FGamebaseCommunicatorReceiveDataPtr& ReceiveData)
    {
        if (OnSchemeEventMap.Contains(ReceiveData->Handle))
        {
            OnSchemeEventMap[ReceiveData->Handle].ExecuteIfBound(ReceiveData->JsonData, GetGamebaseError(ReceiveData.ToSharedRef()).Get());
        }
    });
}

void FGamebaseBridgeImageNotice::ShowImageNotices(const FGamebaseImageNoticeConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback, const FGamebaseImageNoticeEventDelegate& EventCallback)
{
    FImageNoticeSchemeExtraData ExtraData;
    ExtraData.SchemeEvent = NoticeSchemeHandleNumber++;
    OnSchemeEventMap.Add(ExtraData.SchemeEvent, EventCallback);

    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::ShowImageNotices };
    SendData.JsonData = Configuration.ToJson();
    SendData.ExtraData = ExtraData.ToJson(false);

    GamebaseCommunicatorAsyncSender::UseScheme(SendData, Communicator.Get(), CloseCallback, FGamebaseExtraDataDelegate::CreateRaw(this, &FGamebaseBridgeImageNotice::RemoveSchemeEvent));
}

void FGamebaseBridgeImageNotice::CloseImageNotices()
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::CloseImageNotices };

    Communicator->GetAsyncWithoutResponse(SendData.ToJson(false));
}

void FGamebaseBridgeImageNotice::RemoveSchemeEvent(const FString& ExtraData)
{
    const int32 SchemeHandle = FCString::Atoi(*ExtraData);
    OnSchemeEventMap.Remove(SchemeHandle);
}
