#include "GamebaseBridgeGameNotice.h"
#include "GamebaseCommunicator.h"
#include "GamebaseCommunicatorAsyncSender.h"
#include "GamebaseCommunicatorManager.h"
#include "GamebaseCommunicatorAsyncSender.h"

namespace GamebaseScheme
{
    static const FName OpenGameNotice(TEXT("gamebase://openGameNotice"));
}

FGamebaseBridgeGameNotice::FGamebaseBridgeGameNotice(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeGameNotice::OpenGameNotice(const FGamebaseErrorDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData { GamebaseScheme::OpenGameNotice };

    GamebaseCommunicatorAsyncSender::Default(SendData, Communicator.Get(), Callback);
}