#include "GamebaseBridgeCore.h"

#include "GamebaseCommunicationRequestTypes.h"

namespace GamebaseScheme
{
    const FName Initialize(TEXT("gamebase://initialize"));
    const FName SetDebugMode(TEXT("gamebase://setDebugMode"));
}

FGamebaseBridgeCore::FGamebaseBridgeCore(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

FGamebaseBridgeCore::~FGamebaseBridgeCore()
{
}

void FGamebaseBridgeCore::InitializeGamebase(const FGamebaseConfiguration& Configuration, const FGamebaseLaunchingInfoDelegate& Callback)
{
    FGamebaseCommunicatorSendData Data{ GamebaseScheme::Initialize };
    Data.JsonData = Configuration.ToJson();

    Communicator->RegisterAsyncEvent(Data,
        [=](const FGamebaseCommunicatorReceiveDataRef& ReceiveData)
        {
            const auto Error = GetGamebaseError(ReceiveData);
            if (ReceiveData->JsonData.IsEmpty())
            {
                Callback.ExecuteIfBound(nullptr, Error.Get());
                return;
            }

            const FGamebaseLaunchingInfoPtr LaunchingInfo = MakeShared<FGamebaseLaunchingInfo, ESPMode::ThreadSafe>();
            LaunchingInfo->FromJson(ReceiveData->JsonData);
        
            Callback.ExecuteIfBound(LaunchingInfo.Get(), Error.Get());
        });
}

void FGamebaseBridgeCore::SetDebugMode(const bool bIsDebugMode)
{
    FIsDebugMode DebugMode;
    DebugMode.bIsDebugMode = bIsDebugMode;
    
    FGamebaseCommunicatorSendData Data(GamebaseScheme::SetDebugMode);
    Data.JsonData = DebugMode.ToJson(false);

    Communicator->GetAsyncWithoutResponse(Data.ToJson(false));
}