#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebaseContact.h"

class FGamebaseBridgeContact : public IGamebaseContact, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeContact(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeContact() override = default;

    virtual void OpenContact(const FGamebaseErrorDelegate& CloseCallback) override;
    virtual void OpenContact(const FGamebaseContactConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback) override;

    virtual void RequestContactURL(const FGamebaseContactUrlDelegate& Callback) override;
    virtual void RequestContactURL(const FGamebaseContactConfiguration& Configuration, const FGamebaseContactUrlDelegate& Callback) override;
};
