#include "GamebaseBridgeCommunity.h"
#include "GamebaseCommunicator.h"
#include "GamebaseCommunicatorAsyncSender.h"
#include "GamebaseCommunicatorManager.h"
#include "GamebaseCommunicatorAsyncSender.h"

namespace GamebaseScheme
{
    const FName OpenCommunityWithConfiguration(TEXT("gamebase://openCommunityWithConfiguration"));
}

FGamebaseBridgeCommunity::FGamebaseBridgeCommunity(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeCommunity::OpenCommunity(const FGamebaseCommunityConfiguration& Configuration, const FGamebaseErrorDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData { GamebaseScheme::OpenCommunityWithConfiguration };
    SendData.JsonData = Configuration.ToJson();

    GamebaseCommunicatorAsyncSender::Default(SendData, Communicator.Get(), Callback);
}