#pragma once

#include "CoreMinimal.h"
#include "GamebaseBridgeSubsystem.h"
#include "GamebaseCommunicator.h"
#include "GamebaseSubsystemAware.h"

class FGamebaseBridgeBase
    : public TGamebaseSubsystemAware<UGamebaseBridgeSubsystem>
{
public:
    FGamebaseBridgeBase() = delete;
    virtual ~FGamebaseBridgeBase() override = default;

    FGamebaseBridgeBase(
        const TSharedPtr<FGamebaseCommunicatorManager>& Communicator,
        const FName& ClassName)
        : TGamebaseSubsystemAware(UGameInstance::GetSubsystem<UGamebaseBridgeSubsystem>(
              UGamebaseBridgeProvider::GetInstance() && UGamebaseBridgeProvider::GetInstance()->GetWorld()
                  ? UGamebaseBridgeProvider::GetInstance()->GetWorld()->GetGameInstance()
                  : nullptr))
        , Communicator(Communicator)
        , ClassName(ClassName)
    {
        if (Communicator.IsValid())
        {
            Communicator->Initialize(ClassName);
        }
        else
        {
            GAMEBASE_LOG_GLOBAL_WARNING("Failed to initialize FGamebaseBridgeBase: Communicator is invalid.");
        }
    }

protected:
    TSharedPtr<FGamebaseCommunicatorManager> Communicator;
    FName ClassName;
};
