#include "GamebaseBridgeAnalytics.h"
#include "GamebaseCommunicator.h"

namespace GamebaseScheme
{
    const FName SetGameUserData(TEXT("gamebase://setGameUserData"));
    const FName TraceLevelUp(TEXT("gamebase://traceLevelUp"));
}


FGamebaseBridgeAnalytics::FGamebaseBridgeAnalytics(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeAnalytics::SetGameUserData(const FGamebaseAnalyticsUserData& GameUserData)
{
    FGamebaseCommunicatorSendData Data(GamebaseScheme::SetGameUserData);
    Data.JsonData = GameUserData.ToJson();

    Communicator->GetAsyncWithoutResponse(Data.ToJson(false));
}

void FGamebaseBridgeAnalytics::TraceLevelUp(const FGamebaseAnalyticsLevelUpData& LevelUpData)
{
    FGamebaseCommunicatorSendData Data(GamebaseScheme::TraceLevelUp);
    Data.JsonData = LevelUpData.ToJson();
    
    Communicator->GetAsyncWithoutResponse(Data.ToJson(false));
}
