#pragma once

#include "CoreMinimal.h"
#include "GamebaseJsonSerializerMacros.h"
#include "Types/GamebaseError.h"

struct FGamebaseCommunicatorSendData final : FGamebaseJsonSerializable
{
    FString Scheme;
    int32 Handle = 0;
    FString ObjectName;
    FString JsonData;
    FString ExtraData;

    explicit FGamebaseCommunicatorSendData(const FName& Scheme) : Scheme(Scheme.ToString()) {}

    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("scheme", Scheme);
        GAMEBASE_JSON_SERIALIZE("handle", Handle);
        GAMEBASE_JSON_SERIALIZE("gameObjectName", ObjectName);
        GAMEBASE_JSON_SERIALIZE("jsonData", JsonData);
        GAMEBASE_JSON_SERIALIZE("extraData", ExtraData);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FGamebaseCommunicatorReceiveData final : FGamebaseJsonSerializable
{
    FString Scheme;
    int32 Handle;
    FString JsonData;
    FString ExtraData;
    FString GamebaseError;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("scheme", Scheme);
        GAMEBASE_JSON_SERIALIZE("handle", Handle);
        GAMEBASE_JSON_SERIALIZE("jsonData", JsonData);
        GAMEBASE_JSON_SERIALIZE("extraData", ExtraData);
        GAMEBASE_JSON_SERIALIZE("gamebaseError", GamebaseError);
    END_GAMEBASE_JSON_SERIALIZER
};

using FGamebaseCommunicatorReceiveDataPtr = TSharedPtr<FGamebaseCommunicatorReceiveData, ESPMode::ThreadSafe>;
using FGamebaseCommunicatorReceiveDataRef = TSharedRef<FGamebaseCommunicatorReceiveData, ESPMode::ThreadSafe>;

DECLARE_MULTICAST_DELEGATE_OneParam(FGamebaseCommunicatorRecvDataDelegate, FGamebaseCommunicatorReceiveDataPtr);


static FGamebaseErrorPtr GetGamebaseError(const FGamebaseCommunicatorReceiveDataRef& ReceiveData)
{
    if (ReceiveData->GamebaseError.IsEmpty())
    {
        return nullptr;
    }
    
    const FGamebaseErrorPtr Error = MakeShared<FGamebaseError, ESPMode::ThreadSafe>();
    Error->FromJson(ReceiveData->GamebaseError);
    
    return Error;
}
