﻿#pragma once

#include "CoreMinimal.h"
#include "GamebaseCommunicatorTypes.h"

class IGamebaseCommunicator;

class FGamebaseCommunicatorManager final : public TSharedFromThis<FGamebaseCommunicatorManager>
{
public:
    using FCommunicatorCallback = TFunction<void(FGamebaseCommunicatorReceiveDataRef)>;
    
public:
    explicit FGamebaseCommunicatorManager();
    ~FGamebaseCommunicatorManager();

    void Initialize(const FName& ClassName);
    
    void RegisterEvent(const FName& Scheme, const FCommunicatorCallback& Callback);
    void RegisterAsyncEvent(FGamebaseCommunicatorSendData Data, FCommunicatorCallback Callback = nullptr);
    void ReceiveEvent(FGamebaseCommunicatorReceiveDataPtr Result);

    void GetAsyncWithoutResponse(const FString& JsonString);
    
    FString GetSync(const FString& JsonString);
    
private:
    void RegisterHandleCallback(int32 Handle, const FCommunicatorCallback& Callback);
    void UnregisterHandleCallback(int32 Handle);
    
private:
    FCriticalSection CriticalSection;
    TMap<int32, FCommunicatorCallback> HandleCallbacks;
    TMap<FName, FCommunicatorCallback> SchemeCallbacks;
    
    TUniquePtr<IGamebaseCommunicator> Communicator;
};