#pragma once

#include "CoreMinimal.h"
#include "GamebaseWebViewTypes.h"

struct FIsDebugMode final : FGamebaseJsonSerializable
{
    bool bIsDebugMode;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("isDebugMode", bIsDebugMode);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FAuthProviderInfo final : FGamebaseJsonSerializable
{
    FString ProviderName;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("providerName", ProviderName);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FAuthAddMappingForcibly final : FGamebaseJsonSerializable
{
    FString ProviderName;
    FString ForcingMappingKey;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("providerName", ProviderName);
        GAMEBASE_JSON_SERIALIZE("forcingMappingKey", ForcingMappingKey);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FAuthTransferAccount final : FGamebaseJsonSerializable
{
    FString AccountId;
    FString AccountPassword;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("accountId", AccountId);
        GAMEBASE_JSON_SERIALIZE("accountPassword", AccountPassword);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FPurchaseItemSeq final : FGamebaseJsonSerializable
{
    int64 ItemSeq;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("itemSeq", ItemSeq);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FPurchaseProductId final : FGamebaseJsonSerializable
{
    FString GamebaseProductId;
    FString Payload;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        GAMEBASE_JSON_SERIALIZE("payload", Payload);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FUtilAlertDialog final : FGamebaseJsonSerializable
{
    FString Title;
    FString Message;
    int32 Duration;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("title", Title);
        GAMEBASE_JSON_SERIALIZE("message", Message);
        GAMEBASE_JSON_SERIALIZE("duration", Duration);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FWebviewConfiguration final : FGamebaseJsonSerializable
{
    FString Url;
    FGamebaseWebViewConfiguration Configuration;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("url", Url);
        GAMEBASE_JSON_SERIALIZE_OBJECT_SERIALIZABLE("configuration", Configuration);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FWebviewSchemeExtraData final : FGamebaseJsonSerializable
{
    TArray<FString> SchemeList;
    int32 SchemeEvent;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE_ARRAY("schemeList", SchemeList);
        GAMEBASE_JSON_SERIALIZE("schemeEvent", SchemeEvent);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FImageNoticeSchemeExtraData final : FGamebaseJsonSerializable
{
    int32 SchemeEvent;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("schemeEvent", SchemeEvent);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FPushIsSandboxMode final : FGamebaseJsonSerializable
{
    bool bIsSandbox;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("isSandbox", bIsSandbox);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FLoggerSendMessage final : FGamebaseJsonSerializable
{
    FString Message;
    TMap<FString, FString> UserFields;

    FLoggerSendMessage() = default;
    FLoggerSendMessage(const FString& Message, const TMap<FString, FString>& UserFields)
        : Message(Message)
        , UserFields(UserFields)
    {
    }
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("message", Message);
        GAMEBASE_JSON_SERIALIZE_MAP("userFields", UserFields);
    END_GAMEBASE_JSON_SERIALIZER
};

struct FLoggerUserField final : FGamebaseJsonSerializable
{
    FString Key;
    FString Value;
    
    BEGIN_GAMEBASE_JSON_SERIALIZER
        GAMEBASE_JSON_SERIALIZE("key", Key);
        GAMEBASE_JSON_SERIALIZE("value", Value);
    END_GAMEBASE_JSON_SERIALIZER
};

DECLARE_DELEGATE_OneParam(FGamebaseExtraDataDelegate, const FString&);