#include "GamebaseAndroidPurchase.h"

namespace GamebaseScheme
{
    const FName RequestSubscriptionsStatus(TEXT("gamebase://requestSubscriptionsStatus"));
}

namespace GamebaseCommunicatorAsyncSender
{
    void SubscriptionsStatus(const FGamebaseCommunicatorSendData& SendData, FGamebaseCommunicatorManager* Communicator, const FGamebasePurchasableSubscriptionStatusDelegate& Callback)
    {
        Communicator->RegisterAsyncEvent(SendData, [=](const FGamebaseCommunicatorReceiveDataRef& ReceiveData)
        {
            const auto Error = GetGamebaseError(ReceiveData);
            if (ReceiveData->JsonData.IsEmpty())
            {
                Callback.ExecuteIfBound(nullptr, Error.Get());
                return;
            }

            const TSharedPtr<TArray<FGamebasePurchasableSubscriptionStatus>> ResultList = MakeShared<TArray<FGamebasePurchasableSubscriptionStatus>>(
                GamebaseJsonUtils::ConvertJsonStringToJsonArray<FGamebasePurchasableSubscriptionStatus>(ReceiveData->JsonData));
            Callback.ExecuteIfBound(ResultList.Get(), Error.Get());
        });
    }
}


void FGamebaseAndroidPurchase::RequestSubscriptionsStatus(const FGamebasePurchasableConfiguration& Configuration,
    const FGamebasePurchasableSubscriptionStatusDelegate& Callback)
{
    FGamebaseCommunicatorSendData Data{ GamebaseScheme::RequestSubscriptionsStatus };
    Data.JsonData = Configuration.ToJson();
    Data.ExtraData = Configuration.ToJson();    //TODO: extra configuration 필요한지 확인 필요
    
    GamebaseCommunicatorAsyncSender::SubscriptionsStatus(Data, Communicator.Get(), Callback);
}
