#pragma once

class FJsonObject;
struct FJsonSerializerBase;

struct GAMEBASE_API FGamebaseValueObject
{
    virtual ~FGamebaseValueObject() = default;

    virtual FString ToJson();
    virtual FString ToJson() const;
    virtual FString ToPrettyJson();
    virtual FString ToPrettyJson() const;

    virtual bool FromJson(const FString& Json);
    virtual bool FromJson(FString&& Json);
    virtual bool FromJson(TSharedPtr<FJsonObject> JsonObject);

    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) = 0;
};
