#pragma once

#include "CoreMinimal.h"
#include "GamebaseValueObject.h"
#include "GamebaseTransferAccountRenewConfiguration.generated.h"

UENUM()
enum class EGamebaseRenewalTargetType : uint8
{
    Password,
    IdPassword,
};

namespace TransferAccountValue
{
    const FString RenewalModeManual = "MANUAL";
    const FString RenewalModeAuto = "AUTO";
}

struct GAMEBASE_API FGamebaseTransferAccountRenewConfiguration final : FGamebaseValueObject
{
    FString RenewalModeType;
    EGamebaseRenewalTargetType RenewalTargetType;
    FString AccountId;
    FString AccountPassword;

    FGamebaseTransferAccountRenewConfiguration() = default;

    FGamebaseTransferAccountRenewConfiguration(const FString& accountId, const FString& accountPassword)
        : RenewalModeType(TransferAccountValue::RenewalModeManual)
        , RenewalTargetType(EGamebaseRenewalTargetType::IdPassword)
        , AccountId(accountId)
        , AccountPassword(accountPassword)
    {
    }

    FGamebaseTransferAccountRenewConfiguration(const FString& accountPassword)
        : RenewalModeType(TransferAccountValue::RenewalModeManual)
        , RenewalTargetType(EGamebaseRenewalTargetType::Password)
        , AccountPassword(accountPassword)
    {
    }

    FGamebaseTransferAccountRenewConfiguration(EGamebaseRenewalTargetType type)
        : RenewalModeType(TransferAccountValue::RenewalModeAuto)
        , RenewalTargetType(type)
    {
    }
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};
