#pragma once

#include "CoreMinimal.h"
#include "GamebaseDataContainer.h"
#include "GamebaseError.h"

struct GAMEBASE_API FGamebaseTermsConfiguration final : FGamebaseValueObject
{
    bool bForceShow = false;
    bool bEnableFixedFontSize = false;       // Android Only
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

struct GAMEBASE_API FGamebaseTermsContent final : FGamebaseValueObject
{
    int32 TermsContentSeq;
    bool bAgreed;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

struct GAMEBASE_API FGamebaseUpdateTermsConfiguration final : FGamebaseValueObject
{
    int32 TermsSeq;
    FString TermsVersion;
    TArray<FGamebaseTermsContent> Contents;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


using FGamebaseQueryTermsResultPtr = TSharedPtr<struct FGamebaseQueryTermsResult, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseQueryTermsResult final : FGamebaseValueObject
{
    struct FContentDetail final
    {
        int32 TermsContentSeq;
        FString Name;
        bool bRequired;
        FString AgreePush;
        bool bAgreed;
        int32 Node1DepthPosition;
        int32 Node2DepthPosition;
        FString DetailPageUrl;
    };
    
    FString TermsVersion;
    int32 TermsSeq;
    FString TermsCountryType;
    TArray<FContentDetail> Contents;

    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


using FGamebaseShowTermsViewResultPtr = TSharedPtr<struct FGamebaseShowTermsViewResult, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseShowTermsViewResult final : FGamebaseValueObject
{
    bool bIsTermsUIOpened;

    static FGamebaseShowTermsViewResultPtr From(const FGamebaseDataContainer* DataContainer);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


DECLARE_DELEGATE_TwoParams(FGamebaseQueryTermsResultDelegate, const FGamebaseQueryTermsResult*, const FGamebaseError*);