#pragma once

#include "CoreMinimal.h"
#include "GamebaseDataContainer.h"
#include "GamebaseNotificationPriority.h"

using FGamebasePushConfigurationPtr = TSharedPtr<struct FGamebasePushConfiguration, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebasePushConfiguration final : FGamebaseValueObject
{
    bool bPushEnabled;
    bool bADAgreement;
    bool bADAgreementNight;
    FString DisplayLanguageCode;

    /**
     * Android only
     * This field automatically calls the requestPermission("android.permission.POST_NOTIFICATIONS") after a successful registerPush call on Android 13 or higher OS.
     */
    TOptional<bool> bRequestNotificationPermission;

    /**
     * iOS only
     * If set to `true', the token will be registered even if you don't have permission to grant notifications. The default value is `false`.
     */
    TOptional<bool> bAlwaysAllowTokenRegistration;

    static FGamebasePushConfigurationPtr From(const FGamebaseDataContainer* DataContainer);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


using FGamebaseNotificationOptionsPtr = TSharedPtr<struct FGamebaseNotificationOptions, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseNotificationOptions final : FGamebaseValueObject
{
    bool bForegroundEnabled = false;
    bool bBadgeEnabled = true;
    bool bSoundEnabled = true;           // iOS Only
    int32 Priority = GamebaseNotificationPriority::High;    // Android Only
    FString SmallIconName;              // Android Only
    FString SoundFileName;              // Android Only
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


using FGamebasePushTokenInfoPtr = TSharedPtr<struct FGamebasePushTokenInfo, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebasePushTokenInfo final : FGamebaseValueObject
{
    struct FAgreement final
    {
        bool bPushEnabled;
        bool bAdAgreement;
        bool bAdAgreementNight;
    };
    
    bool bSandbox;               // iOS Only
    FString PushType;
    FString Token;
    FString UserId;
    FString DeviceCountryCode;
    FString Timezone;
    FString RegisteredDateTime;
    FString LanguageCode;
    FAgreement Agreement;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

DECLARE_DELEGATE_TwoParams(FGamebasePushConfigurationDelegate, const FGamebasePushConfiguration*, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FGamebasePushTokenInfoDelegate, const FGamebasePushTokenInfo*, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FGamebaseQueryNotificationAllowedDelegate, bool, const FGamebaseError*);