#pragma once

#include "CoreMinimal.h"
#include "GamebaseError.h"

struct GAMEBASE_API FGamebasePurchasableConfiguration final : FGamebaseValueObject
{
    bool bAllStores = false;
    bool bIncludeExpiredSubscriptions = false;

    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

struct GAMEBASE_API FGamebasePurchasableItem final : FGamebaseValueObject
{
    FString GamebaseProductId;
    int64 ItemSeq;
    float Price;
    FString Currency;
    FString ItemName;
    FString MarketItemId;
    FString ProductType;
    FString LocalizedPrice;
    FString LocalizedTitle;
    FString LocalizedDescription;
    bool bIsActive;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebasePurchasableReceiptPtr = TSharedPtr<struct FGamebasePurchasableReceipt, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebasePurchasableReceipt : FGamebaseValueObject
{
    FString GamebaseProductId;
    int64 ItemSeq;
    float Price;
    FString Currency;
    FString PaymentSeq;
    FString PurchaseToken;
    FString MarketItemId;
    FString ProductType;
    FString UserId;
    FString PaymentId;
    TOptional<FString> OriginalPaymentId;
    int64 PurchaseTime;
    int64 ExpiryTime;
    FString StoreCode;
    TOptional<FString> Payload;
    TOptional<bool> bIsPromotion;
    TOptional<bool> bIsTestPurchase;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;

    bool operator==(const FGamebasePurchasableReceipt& Other) const
    {
        return this->PaymentSeq == Other.PaymentSeq && this->PurchaseToken == Other.PurchaseToken;
    }
};

struct GAMEBASE_API FGamebasePurchasableSubscriptionStatus final : FGamebaseValueObject
{
    FString GamebaseProductId;
    int64 ItemSeq;
    FString StoreCode;
    FString PaymentId;
    TOptional<FString> OriginalPaymentId;
    FString PaymentSeq;
    FString MarketItemId;
    FString ProductType;
    FString UserId;
    float Price;
    FString Currency;
    FString PurchaseToken;
    int64 PurchaseTime;
    int64 ExpiryTime;
    int32 StatusCode;
    FString StatusDescription;
    TOptional<FString> Payload;
    TOptional<FString> PurchaseType;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

DECLARE_DELEGATE_TwoParams(FGamebasePurchasableReceiptDelegate, const FGamebasePurchasableReceipt*, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FGamebasePurchasableReceiptListDelegate, const TArray<FGamebasePurchasableReceipt>*, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FGamebasePurchasableItemListDelegate, const TArray<FGamebasePurchasableItem>*, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FGamebasePurchasableSubscriptionStatusDelegate, const TArray<FGamebasePurchasableSubscriptionStatus>*, const FGamebaseError*);